<?php
require_once 'database.php';

$name = $_GET['name'] ?? '';
$session_timeout = $_GET['session_timeout'] ?? '';
$idle_timeout = $_GET['idle_timeout'] ?? '';
$shared_users = $_GET['shared_users'] ?? '';
$rate_limit = $_GET['rate_limit'] ?? '';
$status_refresh = $_GET['status_refresh'] ?? '';
$mac_cookie_timeout = $_GET['mac_cookie_timeout'] ?? '';

if ($name !== '') {
    $conn = getDBConnection();
    // Upsert: update if exists, else insert
    $stmt = $conn->prepare("INSERT INTO hotspot_profiles (name, session_timeout, idle_timeout, shared_users, rate_limit, status_refresh, mac_cookie_timeout)
        VALUES (?, ?, ?, ?, ?, ?, ?)
        ON DUPLICATE KEY UPDATE
            session_timeout=VALUES(session_timeout),
            idle_timeout=VALUES(idle_timeout),
            shared_users=VALUES(shared_users),
            rate_limit=VALUES(rate_limit),
            status_refresh=VALUES(status_refresh),
            mac_cookie_timeout=VALUES(mac_cookie_timeout)
    ");
    $stmt->bind_param('sssssss', $name, $session_timeout, $idle_timeout, $shared_users, $rate_limit, $status_refresh, $mac_cookie_timeout);
    $stmt->execute();
    $stmt->close();
    $conn->close();
    echo "OK";
} else {
    echo "Missing name";
}
?>