<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
require_once __DIR__ . '/dashboard/database.php';

// 1. Receive and log the posted data
$data = json_decode(file_get_contents('php://input'), true);
file_put_contents('hotspot_sms_log.txt', date('Y-m-d H:i:s') . " - Incoming: " . json_encode($data) . "\n", FILE_APPEND);

if (!isset($data['username'])) {
    echo json_encode(['success' => false, 'message' => 'Username not provided.']);
    exit;
}

$username = $data['username'];
$conn = getDBConnection();

// 2. Select password, account_name, profile, transaction_id from hotspot_accounts
$stmt = $conn->prepare("SELECT password, account_name, profile, transaction_id FROM hotspot_accounts WHERE username=? LIMIT 1");
$stmt->bind_param('s', $username);
$stmt->execute();
$stmt->bind_result($password, $account_name, $profile, $transaction_id);
if (!$stmt->fetch()) {
    $stmt->close();
    $conn->close();
    echo json_encode(['success' => false, 'message' => 'Account not found.']);
    exit;
}
$stmt->close();

// 3. Select description from hotspot_packages where profile = $profile
$stmt = $conn->prepare("SELECT description FROM hotspot_packages WHERE profile=? LIMIT 1");
$stmt->bind_param('s', $profile);
$stmt->execute();
$stmt->bind_result($description);
$stmt->fetch();
$stmt->close();

// 4. Select amount from transaction_history where transaction_id = $transaction_id?
$stmt = $conn->prepare("SELECT amount FROM transaction_history WHERE transaction_id=? LIMIT 1");
$stmt->bind_param('s', $transaction_id);
$stmt->execute();
$stmt->bind_result($amount);
$stmt->fetch();
$stmt->close();

// 5. Select content from message_templates where recipient = 'Client'
$stmt = $conn->prepare("SELECT content FROM message_templates WHERE recipient='Client' LIMIT 1");
$stmt->execute();
$stmt->bind_result($template_content);
$stmt->fetch();
$stmt->close();

// 6. Replace template keys with actual values
$replacements = [
    '{{name}}' => $account_name,
    '{{transid}}' => $transaction_id,
    '{{package}}' => $profile,
    '{{description}}' => $description,
    '{{amount}}' => $amount,
    '{{password}}' => $password,
    '{{username}}' => $username
];
$message = strtr($template_content, $replacements);

// 7. Send SMS using Hubtel
$fields = [
    'From' => 'Ewusiawa',
    'To' => $username,
    'Content' => $message,
    'ClientReference' => $transaction_id
];

$headers = [
    "Authorization: Basic " . base64_encode("zsjfxoty:ojfofwse"),
    "Content-Type: application/json"
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "https://sms.hubtel.com/v1/messages/send");
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

$response = curl_exec($ch);
$responseCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// Log SMS response
file_put_contents('hotspot_sms_log.txt', date('Y-m-d H:i:s') . " - SMS Response: $responseCode - $response\n", FILE_APPEND);

// Parse response JSON
$responseData = json_decode($response, true);

// Prepare values for insert
$rate = isset($responseData['rate']) ? $responseData['rate'] : null;
$message_id = isset($responseData['messageId']) ? $responseData['messageId'] : null;
$status = isset($responseData['status']) ? $responseData['status'] : null;
$status_description = isset($responseData['statusDescription']) ? $responseData['statusDescription'] : null;
$network_id = isset($responseData['networkId']) ? $responseData['networkId'] : null;

// Insert log into sent_sms_logs
$stmt = $conn->prepare("INSERT INTO sent_sms_logs (recipient, message_content, response_code, rate, message_id, status, status_description, network_id, raw_response, sent_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())");
$stmt->bind_param(
    'ssidsisss',
    $username,
    $message,
    $responseCode,
    $rate,
    $message_id,
    $status,
    $status_description,
    $network_id,
    $response
);
$stmt->execute();
$stmt->close();

// 8. Select a verified payout account
$stmt = $conn->prepare("SELECT network_type, account_number, account_name FROM payout_accounts WHERE is_verified=1 LIMIT 1");
$stmt->execute();
$stmt->bind_result($network_type, $account_number, $payout_account_name);
if (!$stmt->fetch()) {
    $stmt->close();
    $conn->close();
    echo json_encode(['success' => false, 'message' => 'No verified payout account found.']);
    exit;
}
$stmt->close();

// 9. Calculate payout amount (97%)
// $payout_amount = $amount; // No deduction, use the original amount
// $payout_transaction_id = $transaction_id . 'Payout';

// 10. Prepare payout POST data
// $payout_data = [
//     "customer_number" => $account_number,
//     "amount" => $payout_amount,
//     "transaction_id" => $payout_transaction_id,
//     "network_code" => $network_type,
//     "callback_url" => "https://emceeconnect.online/payout_callback.php",
//     "description" => "Payout for $description, from KROLATECH"
// ];

// 11. Send payout request
$payout_ch = curl_init();
curl_setopt($payout_ch, CURLOPT_URL, "https://bundle.krolatech.org/wifi_disburse.php");
curl_setopt($payout_ch, CURLOPT_POST, 1);
curl_setopt($payout_ch, CURLOPT_POSTFIELDS, json_encode($payout_data));
curl_setopt($payout_ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($payout_ch, CURLOPT_HTTPHEADER, ["Content-Type: application/json"]);
$payout_response = curl_exec($payout_ch);
$payout_response_code = curl_getinfo($payout_ch, CURLINFO_HTTP_CODE);
curl_close($payout_ch);

// Log payout response
file_put_contents('hotspot_sms_log.txt', date('Y-m-d H:i:s') . " - Payout Response: $payout_response_code - $payout_response\n", FILE_APPEND);

// 12. Insert payout transaction into transaction_history
$payout_status = 'Paid';
$payout_source = 'PAYOUT';
$payout_profile = $profile;

$stmt = $conn->prepare("INSERT INTO transaction_history (username, momo_number, network, transaction_id, amount, profile, status, source, account_name) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
$stmt->bind_param(
    'ssssdssss',
    $account_number,         // username
    $account_number,         // momo_number
    $network_type,           // network
    $payout_transaction_id,  // transaction_id
    $payout_amount,          // amount
    $payout_profile,         // profile
    $payout_status,          // status
    $payout_source,          // source
    $payout_account_name     // account_name
);
$stmt->execute();
$stmt->close();

if ($responseCode == 200) {
    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'message' => 'Failed to send SMS.']);
}