<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Payment Successful - Ewusiwa Hostel WiFi</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <script src="https://cdn.tailwindcss.com"></script>
  <link href="https://fonts.googleapis.com/css?family=Pacifico&display=swap" rel="stylesheet">
  <style>
    body {
      background: radial-gradient(circle at 60% 40%, #22c55e 0%, #bbf7d0 60%, #fff 100%);
      min-height: 100vh;
      font-family: 'Segoe UI', Arial, sans-serif;
    }
    .card-animate {
      animation: cardPop 1.2s cubic-bezier(.68,-0.55,.27,1.55);
    }
    @keyframes cardPop {
      0% { transform: scale(0.7) translateY(60px); opacity: 0; }
      60% { transform: scale(1.05) translateY(-10px); opacity: 1; }
      80% { transform: scale(0.98) translateY(0); }
      100% { transform: scale(1) translateY(0); }
    }
    .confetti {
      position: absolute;
      width: 100%;
      height: 100%;
      pointer-events: none;
      overflow: hidden;
      top: 0; left: 0;
      z-index: 10;
    }
    .confetti-piece {
      position: absolute;
      width: 12px;
      height: 12px;
      border-radius: 2px;
      opacity: 0.8;
      animation: confettiDrop 2.5s linear infinite;
    }
    @keyframes confettiDrop {
      0% { transform: translateY(-40px) rotate(0deg); }
      100% { transform: translateY(600px) rotate(360deg); }
    }
    .logo-animate {
      animation: logoPop 1.2s cubic-bezier(.68,-0.55,.27,1.55);
    }
    @keyframes logoPop {
      0% { transform: scale(0.6) rotate(-20deg); opacity: 0; }
      60% { transform: scale(1.1) rotate(10deg); opacity: 1; }
      80% { transform: scale(0.98) rotate(0deg); }
      100% { transform: scale(1) rotate(0deg); }
    }
    .handwrite {
      font-family: 'Pacifico', cursive;
      font-size: 2rem;
      stroke: #22c55e;
      stroke-width: 2px;
      fill: none;
      paint-order: stroke fill;
    }
  </style>
</head>
<body class="flex flex-col items-center justify-center relative">
  <!-- Animated Thank You Message -->
  <div class="relative flex flex-col items-center justify-center mt-10 mb-2" style="height: 70px;">
    <div id="confetti" class="confetti" style="display:none;"></div>
    <svg id="thankyou-svg" width="380" height="50" viewBox="0 0 380 50" fill="none" xmlns="http://www.w3.org/2000/svg" class="block mx-auto">
      <text x="50%" y="50%" text-anchor="middle" dy=".35em"
        class="handwrite"
        id="thankyou-text"
      >Thank you for your purchase!</text>
    </svg>
  </div>
  <!-- Card Section -->
  <div class="card-animate bg-white/95 backdrop-blur-lg rounded-3xl shadow-2xl p-10 max-w-md w-full text-center relative z-20 border-2 border-green-400">
    <div class="flex justify-center mb-4">
      <img src="logo.jpg" alt="Ewusiwa Hostel WiFi Logo" class="logo-animate w-20 h-20 rounded-full shadow-lg border-2 border-green-400 bg-white object-cover" />
    </div>
    <!-- <div class="flex justify-center mb-6">
      <div class="animate-bounce">
        <svg class="w-16 h-16 text-green-500 mx-auto drop-shadow-lg" fill="none" viewBox="0 0 48 48">
          <circle cx="24" cy="24" r="22" fill="#bbf7d0" stroke="#22c55e" stroke-width="3"/>
          <path stroke="#22c55e" stroke-width="4" stroke-linecap="round" stroke-linejoin="round" d="M16 25l6 6 10-12"/>
        </svg>
      </div>
    </div> -->
    <h1 class="text-2xl font-extrabold mb-2 text-green-700">Payment Successful!</h1>
    <div class="bg-green-50 rounded-xl p-5 mb-4 border border-green-300 shadow-sm">
      <p class="text-green-700 font-semibold text-lg">Login password has been sent to the receiver's phone number.</p>
      <p class="text-gray-500 mt-2 text-base">Please check your SMS inbox.</p>
    </div>
    <a href="http://ewusiawahostel.com" target="_blank" class="mt-6 px-8 py-3 bg-gradient-to-r from-green-500 to-green-400 text-white rounded-xl font-bold shadow-lg hover:scale-105 transition-all duration-300 inline-block text-lg">
      Go to Home
    </a>
    <div class="mt-8">
      <span class="text-gray-400 text-sm">Need help? <a href="tel:0551387568" class="text-green-600 underline font-semibold">Contact Support</a></span>
    </div>
  </div>
  <script>
    // Handwriting effect for SVG text
    const svgText = document.getElementById('thankyou-text');
    const svg = document.getElementById('thankyou-svg');
    const confetti = document.getElementById('confetti');
    let length = svgText.getComputedTextLength();
    svgText.setAttribute('stroke-dasharray', length);
    svgText.setAttribute('stroke-dashoffset', length);

    function animateDraw() {
      svgText.setAttribute('stroke-dashoffset', length);
      svgText.setAttribute('fill', 'none');
      svg.style.opacity = 1;
      confetti.style.display = 'none';

      // Animate handwriting
      let start = null;
      function drawStep(ts) {
        if (!start) start = ts;
        let progress = Math.min((ts - start) / 1800, 1); // 1.8s draw
        svgText.setAttribute('stroke-dashoffset', length * (1 - progress));
        if (progress < 1) {
          requestAnimationFrame(drawStep);
        } else {
          // Pop in
          svg.style.transition = 'transform 0.4s cubic-bezier(.68,-0.55,.27,1.55), opacity 0.4s';
          svg.style.transform = 'scale(1.15)';
          svgText.setAttribute('fill', '#22c55e');
          confetti.style.display = 'block';
          setTimeout(() => {
            svg.style.transform = 'scale(1)';
          }, 400);
          // Pop out after 1.2s
          setTimeout(() => {
            svg.style.opacity = 0;
            confetti.style.display = 'none';
            setTimeout(animateDraw, 600); // Loop
          }, 1200);
        }
      }
      requestAnimationFrame(drawStep);
    }
    animateDraw();

    // Confetti generator (green/white theme)
    const colors = ["#22c55e", "#bbf7d0", "#fff", "#4ade80", "#86efac"];
    function createConfetti() {
      confetti.innerHTML = '';
      for(let i=0; i<36; i++) {
        const piece = document.createElement('div');
        piece.className = 'confetti-piece';
        piece.style.left = Math.random() * 100 + 'vw';
        piece.style.top = Math.random() * -40 + 'px';
        piece.style.background = colors[Math.floor(Math.random()*colors.length)];
        piece.style.animationDelay = (Math.random()*2) + 's';
        confetti.appendChild(piece);
      }
    }
    createConfetti();
  </script>
</body>
</html>