<?php
require_once 'database.php';

// 🔹 Log RAW request immediately
$logFile = __DIR__ . '/hotspot_profiles.log';
$logData = date('Y-m-d H:i:s') . " | " . http_build_query($_GET) . PHP_EOL;
file_put_contents($logFile, $logData, FILE_APPEND);

// 🔹 Extract parameters
$router_name = $_GET['router_name'] ?? '';
$name = $_GET['name'] ?? '';
$session_timeout = $_GET['session_timeout'] ?? '';
$idle_timeout = $_GET['idle_timeout'] ?? '';
$shared_users = $_GET['shared_users'] ?? '';
$rate_limit = $_GET['rate_limit'] ?? '';
$status_refresh = $_GET['status_refresh'] ?? '';
$mac_cookie_timeout = $_GET['mac_cookie_timeout'] ?? '';

// 🔹 Database insert/update
if ($router_name !== '' && $name !== '') {
    $conn = getDBConnection();

    $stmt = $conn->prepare("
        INSERT INTO hotspot_profiles 
        (router_name, name, session_timeout, idle_timeout, shared_users, rate_limit, status_refresh, mac_cookie_timeout)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?)
        ON DUPLICATE KEY UPDATE
            session_timeout=VALUES(session_timeout),
            idle_timeout=VALUES(idle_timeout),
            shared_users=VALUES(shared_users),
            rate_limit=VALUES(rate_limit),
            status_refresh=VALUES(status_refresh),
            mac_cookie_timeout=VALUES(mac_cookie_timeout)
    ");
    $stmt->bind_param('ssssssss', $router_name, $name, $session_timeout, $idle_timeout, $shared_users, $rate_limit, $status_refresh, $mac_cookie_timeout);
    $stmt->execute();
    $stmt->close();
    $conn->close();

    echo "OK";
} else {
    echo "Missing router_name or profile name";
}
?>
