<?php
require_once 'database.php';

$payload = json_decode(file_get_contents('php://input'), true);
if (!$payload) { http_response_code(400); exit('Bad JSON'); }

$user = $payload['user'] ?? '';
$rx   = (int)($payload['rx'] ?? 0);
$tx   = (int)($payload['tx'] ?? 0);

if ($user === '') { http_response_code(400); exit('No user'); }

/* 1.  Ensure the user exists in `users` table */
$stmt = $conn->prepare("INSERT IGNORE INTO users (username, profile_name) VALUES (?, '')");
$stmt->bind_param("s", $user);
$stmt->execute();
$stmt->close();

/* 2.  Upsert the latest session snapshot */
$stmt = $conn->prepare("
  INSERT INTO user_sessions (username, bytes_rx, bytes_tx, router_time)
  VALUES (?, ?, ?, NOW())
  ON DUPLICATE KEY UPDATE bytes_rx=VALUES(bytes_rx), bytes_tx=VALUES(bytes_tx), router_time=VALUES(router_time)
");
$stmt->bind_param("sii", $user, $rx, $tx);
$stmt->execute();
$stmt->close();

echo 'OK';
?>
