<?php
// --- Configuration ---
// Define the name of the log file. 
// __DIR__ ensures the path is relative to this script's location.
$logFile = __DIR__ . '/mikrotik_user_data.log';

// --- Main Logic ---

// Get the current date and time for the log entry
$timestamp = date('Y-m-d H:i:s');

// Get the IP address of the MikroTik router that sent the data
$remoteIp = $_SERVER['REMOTE_ADDR'] ?? 'UNKNOWN';

// Prepare the log message header
$logMessage = "--- [ LOG ENTRY: {$timestamp} | From IP: {$remoteIp} ] ---\n";

// Check if there is any data in the URL (query string)
if (!empty($_GET)) {
    
    // Log the RAW query string as it was received
    $logMessage .= "Raw Query String:\n";
    $logMessage .= $_SERVER['QUERY_STRING'] . "\n\n";

    // Log the parsed key-value pairs for easier reading
    $logMessage .= "Parsed Data (from \$_GET):\n";
    foreach ($_GET as $key => $value) {
        // Handle empty values gracefully
        $value = $value !== '' ? $value : '[EMPTY]';
        $logMessage .= "  - {$key}: {$value}\n";
    }

} else {
    // If the script was accessed with no data
    $logMessage .= "Request received with no GET parameters.\n";
}

// Add a separator for the next log entry
$logMessage .= "--------------------------------------------------------\n\n";

// Append the log message to the log file.
// FILE_APPEND: Prevents the file from being overwritten on each request.
// LOCK_EX: Prevents other processes from writing to the file at the same time.
file_put_contents($logFile, $logMessage, FILE_APPEND | LOCK_EX);

// (Optional) Send a success response back.
// This helps confirm the script ran if you ever test the URL in a browser.
http_response_code(200); // Set HTTP status to 200 OK
echo "Data received and logged successfully.";

exit();
?>