<?php
header('Content-Type: text/plain');
require_once __DIR__ . '/dashboard/database.php';

$logFile = __DIR__ . '/mikrotik_debug.log';
function logDebug($msg) {
    global $logFile;
    file_put_contents($logFile, "[" . date('Y-m-d H:i:s') . "] $msg\n", FILE_APPEND);
}

logDebug("=== New request received ===");
logDebug("Incoming GET params: " . json_encode($_GET));
logDebug("Incoming POST params: " . json_encode($_POST));

$conn = getDBConnection();
if (!$conn || $conn->connect_error) {
    logDebug("Database connection failed: " . ($conn ? $conn->connect_error : 'No connection object'));
    echo "# DB connection error\n";
    exit;
}
logDebug("Database connection successful");

// Fetch one pending command
$sql = "SELECT * FROM mikrotik_commands WHERE router_id = 'pending' ORDER BY created_at ASC LIMIT 1";
logDebug("SQL query: $sql");

$result = $conn->query($sql);

if ($result === false) {
    logDebug("Query error: " . $conn->error);
    echo "# Query error\n";
    exit;
}

logDebug("Number of rows fetched: " . $result->num_rows);

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    logDebug("Fetched row: " . json_encode($row));

    // Output command to MikroTik
    echo trim($row['command']) . "\n";
    logDebug("Command sent to MikroTik: " . trim($row['command']));

    // --- NEW: If command is adding a user, extract username and POST to hotspot_sms.php ---
    $addUserPattern = '/^\/ip hotspot user add\s+.*name="?([0-9+]+)"?/i';
    if (preg_match($addUserPattern, $row['command'], $matches)) {
        $username = $matches[1];
        logDebug("Detected add user command. Username: $username");

        // Prepare POST to hotspot_sms.php
        $sms_url = 'https://plutonetwork.online/accra/hotspot_sms.php'; // Change to your actual URL
        $payload = json_encode(['username' => $username]);
        $ch = curl_init($sms_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
        $sms_response = curl_exec($ch);
        $sms_http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        logDebug("hotspot_sms.php response ($sms_http_code): $sms_response");
    }

    // Update status to executed
    $updateSql = "UPDATE mikrotik_commands SET router_id = 'executed', executed_at = NOW() WHERE id = {$row['id']}";
    logDebug("Update SQL: $updateSql");

    if ($conn->query($updateSql)) {
        logDebug("Command ID {$row['id']} marked as executed");
    } else {
        logDebug("Failed to update: " . $conn->error);
    }

} else {
    logDebug("No pending commands found");
    echo "# No pending commands\n";
}

$conn->close();
logDebug("Database connection closed");
?>
