<?php
header('Content-Type: application/json');
require_once 'database.php';

$audience = isset($_GET['audience']) ? $_GET['audience'] : 'ALL';

try {
    $conn = getDBConnection();

    if ($audience === 'ALL' || empty($audience)) {
        $sql = "SELECT COUNT(DISTINCT momo_number) as total FROM transaction_history WHERE momo_number IS NOT NULL AND momo_number != '' AND (router IS NOT NULL OR router IS NULL)";
        $stmt = $conn->prepare($sql);
    } else {
        $sql = "SELECT COUNT(DISTINCT momo_number) as total FROM transaction_history WHERE router = ? AND momo_number IS NOT NULL AND momo_number != ''";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("s", $audience);
    }

    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();

    echo json_encode(['total' => $row['total'] ?? 0]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database query failed: ' . $e->getMessage()]);
}
?>